// MainHook.cpp : Defines the entry point for the DLL application.
//


#include "stdafx.h"
#include "MainHook.h"
#include "WINUSER.H"    //contains all these constants, structs, etc...
						//WINABLE.H more info on hooks



//-------------------------
// Global Variables
//-------------------------
HANDLE	hInstance;				// Global instance handle for	DLL
HHOOK	hhookHooks;				// Hook handle



//-------------------------
// DLL Code
//-------------------------
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	hInstance = hModule;

	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}



//---------------------------------
// Thes are the exported functions.
//---------------------------------
MAINHOOK_API int InstallFilterDLL(void)
{
	//Comment this line and uncomment the next to use the WH_KEYBOARD_LL hook.
	hhookHooks = SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC) KeyboardFunc, (HINSTANCE) hInstance, 0);
	//hhookHooks = SetWindowsHookEx(WH_KEYBOARD_LL,(HOOKPROC) LowLevelKeyboardProc, (HINSTANCE) hInstance, 0);

	return 1;
}


MAINHOOK_API int UnInstallFilterDLL(void)
{
	UnhookWindowsHookEx(hhookHooks);
	return 1;
}








//---------------------------------------------------------------------------
//
// Filter function for the WH_KEYBOARD
//
//---------------------------------------------------------------------------
LRESULT CALLBACK KeyboardFunc (int nCode, WPARAM wParam, LPARAM lParam )
{
	bool		bWinKeyDown = 0;
	bool		bKeyUp = 0;

	if ( nCode = HC_ACTION )
	{
		// Check to see if the CTRL key is pressed && the WM_KEYDOWN message was passed in
        bWinKeyDown = GetAsyncKeyState (VK_LWIN) >> ((sizeof(SHORT) * 8) - 1);
		bKeyUp = (lParam >> ((sizeof(LPARAM) * 8) - 1));   //bKeyup=1   WM_KEYUP

/*
        if (GetAsyncKeyState (VK_LWIN) && 0x8000)
			bWinKeyDown = TRUE;
		else
			bWinKeyDown = FALSE;

		if (lParam && 0x80000000)
			bKeyUp = TRUE;   //bKeyup=1   WM_KEYUP
		else
			bKeyUp = FALSE;
*/

		if ((wParam == 0x57) && bWinKeyDown && !bKeyUp)
		{
			WinExec("C:\\Program Files\\Internet Explorer\\Iexplore.exe" ,SW_SHOWNORMAL);
			return 1;  //Returning false disallows the w to be sent to the focus window
		}
	}

	//Pass all messages on to the next hook in the chain
	return( CallNextHookEx(hhookHooks, nCode, wParam, lParam));
}




//---------------------------------------------------------------------------
//
// Filter function for the WH_KEYBOARD_LL
//
//---------------------------------------------------------------------------
LRESULT CALLBACK LowLevelKeyboardProc(int nCode, WPARAM wParam, LPARAM lParam) 
{ 
	KBDLLHOOKSTRUCT *lpMsg;

    if (nCode = HC_ACTION) 
	{
		lpMsg = (KBDLLHOOKSTRUCT *) lParam;
		
		switch (nCode) 
		{
			case HC_ACTION:
				switch(wParam)
				{
					case WM_KEYDOWN:
						break;
					case WM_KEYUP:
						break;
					case WM_SYSKEYDOWN:
						break;
					case WM_SYSKEYUP:
						break;
					default:
						break;
				}
				break;  
			default:
				break;
		}
	}
    
	//Pass all messages on to the next hook in the chain
	return CallNextHookEx(hhookHooks, nCode, wParam, lParam); 
} 
